/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.recipes.RecipeManager;
import mezz.jei.recipes.RecipeManagerInternal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.integration.jei.InfectionCureCategory;
import net.smileycorp.hordes.integration.jei.InfectionCureWrapper;

@JeiPlugin
public class JEIPluginInfection
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    private static InfectionCureCategory infectionCategory;
    private static List<InfectionCureWrapper> recipes;
    private static RecipeManager recipeManager;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        infectionCategory = new InfectionCureCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{infectionCategory});
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        if (runtime.getRecipeManager() instanceof RecipeManager) {
            recipeManager = (RecipeManager)runtime.getRecipeManager();
        }
    }

    public static void setRecipes(List<ItemStack> cures) {
        RecipeManagerInternal manager;
        if (recipeManager != null && (manager = (RecipeManagerInternal)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)recipeManager, (String)"internal")) != null) {
            for (InfectionCureWrapper recipe : recipes) {
                manager.hideRecipe((Object)recipe, InfectionCureCategory.ID);
            }
            recipes.clear();
            ArrayList<Object> items = new ArrayList<ItemStack>();
            for (ItemStack stack : cures) {
                items.add(stack);
                if (items.size() != 54) continue;
                recipes.add(new InfectionCureWrapper(items));
                items = new ArrayList();
            }
            if (!items.isEmpty()) {
                recipes.add(new InfectionCureWrapper(items));
            }
            for (InfectionCureWrapper recipe : recipes) {
                recipeManager.addRecipe((Object)recipe, InfectionCureCategory.ID);
            }
        }
    }

    public ResourceLocation getPluginUid() {
        return ModDefinitions.getResource("infection");
    }

    static {
        recipes = new ArrayList<InfectionCureWrapper>();
        recipeManager = null;
    }
}

